% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2GM2D.R
\name{HTGM2D}
\alias{HTGM2D}
\title{HTGM2D}
\usage{
HTGM2D(dir, geneList, ontologies, GOGOA3)
}
\arguments{
\item{dir}{character string full path name to the directory acting as result repository}

\item{geneList}{character vector of user-supplied genes of interest}

\item{ontologies}{character vector of 2 ontologies e.g. c("biological_process","cellular_component")}

\item{GOGOA3}{return value of subsetGOGOA()}
}
\value{
returns the return value of Jaccard()
}
\description{
run 2D version of GoMiner
}
\examples{
\dontrun{
# this example takes too long to run, and
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# This example is given in full detail in the package vignette.
# You can generate GOGOA3.RData using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO
# load("~/GODB_RDATA/GOGOA3.RData")
subd<-tempdir()
geneList<-cluster52
ontologies<-c("biological_process","cellular_component")
mat<-HTGM2D(subd,geneList,ontologies,GOGOA3)
}

}
