% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.locs.grid.R
\name{setup.locs.grid}
\alias{setup.locs.grid}
\title{Setup the discrete spatial grid for the HMM}
\usage{
setup.locs.grid(limits, res = "quarter")
}
\arguments{
\item{limits}{can take either a 'data.frame' of -Locations from WC psat tag 
or a pre-determined list of limits as \code{list(xmin, xmax, ymin, ymax)}}

\item{res}{character indicating resolution of grid. 'hycom' is .08 to match 
hycom reanalysis res. 'quarter' and 'one' are .25 and 1 deg, respectively.}
}
\value{
a list of spatial bounds
}
\description{
\code{setup.locs.grid} sets up a discrete spatial grid for the HMM
 
If input limits is a data.frame, longitude limits become +/- 5 degrees and
latitude becomes +/- 10 degrees. You may also input your own list of limits.
}
\examples{
# SET SPATIAL LIMITS
sp.lim <- list(lonmin = -95, lonmax = -52, latmin = 10, latmax = 55)
locs.grid <- setup.locs.grid(sp.lim)

}
\references{
Pedersen MW, Patterson TA, Thygesen UH, Madsen H (2011) 
  Estimating animal behavior and residency from movement data. Oikos 
  120:1281-1290. doi: 10.1111/j.1600-0706.2011.19044.x
}
