% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.hycom.R
\name{get.hycom}
\alias{get.hycom}
\title{Download HYCOM data}
\usage{
get.hycom(limits, time, vars = c("water_temp"), include_latlon = TRUE,
  filename = "", download.file = TRUE, dir = getwd(), depLevels = NULL)
}
\arguments{
\item{limits}{A list of length 4; minlon, maxlon, minlat, maxlat. Longitude values are -180,180}

\item{time}{A vector of length 2 with the minimum and maximum times in form
\code{as.Date(date)}.}

\item{vars}{A list of variables to download. This can contain
'water_temp', 'water_u', 'water_v', 'salinity' or 'surf_el' but is not checked
for errors.}

\item{include_latlon}{Should the array of latitude and longitude values be
included?}

\item{filename}{An optional filename. If provided, then the data is
downloaded to that file. Otherwise the data is not downloaded and the url
is returned.}

\item{download.file}{Logical. Should use the default \code{download.file} to
query the server and download or use the optional \code{curl}. Some users
may need to use \code{curl} in order to get this to work.}

\item{dir}{is local directory where ncdf files should be downloaded to.
default is current working directory. if enter a directory that doesn't
exist, it will be created.}

\item{depLevels}{is an integer describing which depth levels to download from Hycom (e.g. 1=surface). Default is NULL and all levels are downloaded.}
}
\value{
The url used to extract the requested data from the NetCDF subset
  service.
}
\description{
\code{get.hycom} downloads HYbrid Coordinate Ocean Model (HYCOM) data for
given temporal and spatial constraints of your data.
}
\details{
The method may return before the download is completed. It will continue to
display progress  until the download completes. Change the default
\code{download.file} if the download is failing on your platform.
}
\references{
\url{https://hycom.org/}
}
\author{
Function originally written for R by Ben Jones (WHOI) and modified
  by Camrin Braun and Ben Galuardi.
}
