summary.ContObservHMM <-
function(object, ...)
{
	cat("\nThe number of observations: ")
	cat(length(object$Observations))
	cat("\nThe mean of observations: ")
	cat(mean(object$Observations))
	cat("\nThe SD of observations: ")
	cat(sd(object$Observations))
	cat("\nThe max and min of observations: ")
	cat(max(object$Observations))
	cat(" and ")
	cat(min(object$Observations))
	cat("\n\nThe number of Baum-Welch iterations: ")
	cat((nrow(object$Parameters))-1)
	yesno<-ifelse(((object$Viterbi[1,1]) == 0), "not yet ", "already ") 
	cat("\nThe Viterbi algorithm was ")
	cat(yesno)
	cat("executed\n")
	cat("\nThe parameters accumulated so far: \n")
	par<-round(object$Parameters, 2)
	print(par)
	cat("\nThe results accumulated so far: \n")
	res1<-(object$Results[-(nrow(object$Parameters)),3])
	res2<-(object$Results[-(nrow(object$Parameters)),4])
	res3<-(object$Results[-(nrow(object$Parameters)),5])
	res4<-(object$Results[-(nrow(object$Parameters)),6])
	res<-cbind(res1, res2, res3, res4)
	colnames(res)<-c("P", "AIC", "SBIC", "HQIC")
	print(res)
	cat("\n")
}
