is.likert <- function(x) inherits(x, "likert")

as.likert <- function(x, ...) {
  if (is.likert(x)) return(x)
  UseMethod("as.likert")
}

as.likert.data.frame <- function(x, ...) {
  as.likert(data.matrix(x), ...)
}

as.likert.formula <- function(x, ...) {
  data <- list(...)$data
  stop("use one of the idioms
    as.likert(tapply( <appropriate arguments> ))
    as.likert(table( <appropriate arguments> ))",
       call.=FALSE)
  ## data(apple)
  ## as.likert(tapply(apple$pre, apple[,1:2], c))
  ## as.likert(table(apple[,1:2]))
  ##
  ## eventually I will need to automate this:
  ##    data[,deparse(x[[2]])]), data[, x[[3]]]
  ## where you have to manually unpack x[[3]].
}


as.likert.ftable <- function(x, ...) {
  as.likert(as.table(x), ...)
}

as.likert.table <- function(x, ...) {
  as.likert.matrix(x, ...)
}
 
as.likert.matrix <- function(x, rowlabel=NULL, collabel=NULL, ...,
                             ReferenceZero=NULL,
                             xlimEqualLeftRight=FALSE,
                             xTickLabelsPositive=TRUE) {
  ## All the as.likert calls end here.  This one accepts and ignores '...'.
  ## All the others may use the arguments here in their ... arguments.
  if (any(x < 0))
    stop("Argument to the likert() function must be non-negative.",
         call.=FALSE)
  nc <- ncol(x)
  ## if (is.null(ReferenceZero)) ReferenceZero <- (nc+1)/2
  ## if (ReferenceZero < 1) ReferenceZero <- .5
  ## if (ReferenceZero > nc) ReferenceZero <- nc + .5

  ## is.wholenumber <-
  ##   function(x, tol = .Machine$double.eps^0.5)  abs(x - round(x)) < tol

  ## maxcolorset <- if (is.wholenumber(ReferenceZero)) (-nc):nc else c(-rev(1:nc), 1:nc)
  ## start.position <- nc - ceiling(ReferenceZero) + 2
  ## colorset <- maxcolorset[seq(start.position, length=nc)]
  colorset <- ColorSet(nc, ReferenceZero)

  ndnx <- names(dimnames(x))
  if (is.null(dimnames(x))) dimnames(x) <- list(1:nrow(x), NULL)
  if (is.null(dimnames(x)[[1]])) dimnames(x)[[1]] <- 1:nrow(x)
  
  levels <- dimnames(x)[[2]]
  if (is.null(levels)) {
    levels <- LETTERS[1:nc]
    dimnames(x)[[2]] <- levels
  }
  
  if (!is.null(rowlabel)) names(dimnames(x))[1] <- rowlabel
  if (!is.null(collabel)) names(dimnames(x))[2] <- collabel
  
  if(!(0 %in% colorset)) {
    ind.neg <- rev((1:nc)[colorset < 0])
    ind.pos <- (1:nc)[colorset > 0]
    x <- cbind(-x[,ind.neg, drop=FALSE],
               x[,ind.pos, drop=FALSE])
    attr(x, "color.seq") <- c(ind.neg, ind.pos)
    attr(x, "positive.order") <- order(apply(x[, ind.pos, drop=FALSE], 1, sum))
  }
  else { ## (0 %in% colorset)
    if (nc > 1) {
      ind.neg <- rev((1:nc)[colorset < 0])
      ind.pos <- (1:nc)[colorset > 0]
      ind.zero <- (1:nc)[colorset == 0]
      x <- cbind(-x[,ind.zero, drop=FALSE]/2,
                 -x[,ind.neg, drop=FALSE],
                 x[,ind.zero, drop=FALSE]/2,
                 x[,ind.pos, drop=FALSE])
      attr(x, "color.seq") <- c(ind.zero, ind.neg, ind.pos)
      pos.columns <- seq(to=ncol(x), length=length(c(ind.zero,ind.pos)))
      attr(x, "positive.order") <- order(apply(x[, pos.columns, drop=FALSE], 1, sum))
    } else {
      attr(x, "positive.order") <- order(x[, 1])
      x <- cbind(-x/2, x/2)
      attr(x, "color.seq") <- 1
    }
  }
  
  names(dimnames(x)) <- ndnx
  attr(x, "nlevels") <- nc
  attr(x, "original.levels") <- levels
  attr(x, "xlimEqualLeftRight") <- xlimEqualLeftRight
  attr(x, "xTickLabelsPositive") <- xTickLabelsPositive
  attr(x, "ReferenceZero") <- ReferenceZero
  class(x) <- c("likert", class(x))
  x
}
## environment(as.likert.matrix) <- environment(plot.likert)
## assignInNamespace(x, value, ns, pos = -1,
##                   envir = as.environment(pos))
## assignInNamespace("as.likert.matrix", as.likert.matrix, "HH")


as.likert.default <- function(x, ...) {
  ## simple vector because anything else got dispatched elsewhere
  x <- t(x)
  if (is.null(dimnames(x))) dimnames(x) <- list("", 1:length(x))
  if (is.null(dimnames(x)[[1]])) dimnames(x)[[1]] <- ""
  as.likert(x, ...)
}

is.likertCapable <- function(x, ...) {
  is.numeric(x) ||
  is.table(x) ||
  inherits(x, "ftable") ||
  ("package:vcd" %in% search() && is.structable(x)) ||
  is.data.frame(x) ||
  is.listOfNamedMatrices(x)
}


as.likert.listOfNamedMatrices <- function(x, ...) {
  result <- sapply(x, as.likert, simplify=FALSE, ...)
  class(result) <- c("likert", "list")
  result
}

as.likert.array <- function(x, ...)
  as.likert(as.listOfNamedMatrices(x), ...)

rev.likert <- function(x) {
  ## Reverses the rows of a matrix "likert" object,
  ## or each item within a list "likert" object,
  ## and retains all attributes.

  if (is.matrix(x)) {
    z <- x
    z[] <- if (nrow(x)) x[nrow(x):1L, , drop=FALSE] else x
    dimnames(z)[[1]] <- rev(dimnames(x)[[1]])
    z
  }
  else {
    sapply(x, rev, simplify=FALSE)
  }
}

## source("c:/HOME/rmh/HH-R.package/HH/R/as.likert.R")
