% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{build.subgraph}
\alias{build.subgraph}
\title{Build subgraph}
\usage{
build.subgraph(nd, g, edgemode = "directed")
}
\arguments{
\item{nd}{a vector with the nodes for which the subgraph must be built.}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{edgemode}{can be "directed" or "undirected".}
}
\value{
A subgraph with only the supplied nodes.
}
\description{
Build a subgraph with only the supplied nodes and any edges between them.
}
\examples{
data(graph);
anc <- build.ancestors(g);
nd <- anc[["HP:0001371"]];
subg <- build.subgraph(nd, g, edgemode="directed");
}
