% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\name{full.annotation.matrix}
\alias{full.annotation.matrix}
\title{Full annotations matrix}
\usage{
full.annotation.matrix(W, anc, ann.spec)
}
\arguments{
\item{W}{symmetric adjacency weighted matrix of the graph}

\item{anc}{list of the ancestors of the ontology.}

\item{ann.spec}{the annotation matrix of the most specific annotations (0/1): rows are genes and columns are classes.}
}
\value{
a full annotation table T, that is a matrix in which the transitive closure of annotations was performed. 
Rows correspond to genes of the weighted adjiacency matrix and columns to terms. 
\eqn{T[i,j]=1} means that gene \eqn{i} is annotated for the term \eqn{j}, \eqn{T[i,j]=0} means that gene \eqn{i} is not annotated for the term \eqn{j}.
}
\description{
Construct a full annotations table using ancestors and the most specific annotations table w.r.t. a given weighted adjacency matrix (wadj). 
The rows of the full annotations matrix correspond to all the examples of the given weighted adjacency matrix and the columns to the class/terms.
The transitive closure of the annotations is performed.
}
\details{
The examples present in the annotation matrix (\code{ann.spec}) but not in the adjacency weighted matrix (\code{W}) are purged.
}
\examples{
data(wadj);
data(graph);
data(labels);
anc <- build.ancestors(g);
full.ann <- full.annotation.matrix(W, anc, L);
}
\seealso{
\code{\link{weighted.adjacency.matrix}}, \code{\link{build.ancestors}}, \code{\link{specific.annotation.matrix}},
\code{\link{transitive.closure.annotations}}
}
