\name{HDtweedie}
\alias{HDtweedie}
\title{Fits the regularization paths for lasso-type methods of the Tweedie model}
\description{Fits regularization paths for lasso-type methods of the Tweedie model at a sequence of regularization parameters lambda.}
\usage{
HDtweedie(x, y, group = NULL, 
		p = 1.50,
		weights = rep(1,nobs),
		alpha = 1,
		nlambda = 100, 
		lambda.factor = ifelse(nobs < nvars, 0.05, 0.001), 
		lambda = NULL, 
		pf = sqrt(bs), 
		dfmax = as.integer(max(group)) + 1, 
		pmax = min(dfmax * 1.2, as.integer(max(group))), 
		standardize = FALSE,
		eps = 1e-08, maxit = 3e+08)
}
\arguments{
		\item{x}{matrix of predictors, of dimension \eqn{n \times p}{n*p}; each row is an observation vector.}
		\item{y}{response variable. This argument should be non-negative.}
		\item{group}{ To apply the grouped lasso, it is a vector of consecutive integers describing the grouping of the coefficients (see example below). To apply the lasso, the user can ignore this argument, and the vector is automatically generated by treating each variable as a group.}
		\item{p}{the power used for variance-mean relation of Tweedie model. Default is 1.50.}
		\item{weights}{the observation weights. Default is equal weight.}
		\item{alpha}{The elasticnet mixing parameter, with
    \eqn{0\le\alpha\le 1}. The penalty is defined
    as \deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.} \code{alpha=1}
    is the lasso penalty, and \code{alpha=0} the ridge penalty. Default is 1.}
		\item{nlambda}{the number of \code{lambda} values - default is 100.}
		\item{lambda.factor}{the factor for getting the minimal lambda in \code{lambda} sequence, where \code{min(lambda)} = \code{lambda.factor} * \code{max(lambda)}.  \code{max(lambda)} is the smallest value of \code{lambda} for which all coefficients are zero. The default depends on the relationship between \eqn{n} (the number of rows in the matrix of predictors) and \eqn{p} (the number of predictors). If \eqn{n >= p}, the default is \code{0.001},
		close to zero.  If \eqn{n<p}, the default is \code{0.05}.
		A very small value of \code{lambda.factor} will lead to a saturated fit. It takes no effect if there is user-defined \code{lambda} sequence.} 
		\item{lambda}{a user supplied \code{lambda} sequence. Typically, by leaving this option unspecified users can have 
		the program compute its own \code{lambda} sequence based on
		\code{nlambda} and \code{lambda.factor}. Supplying a value of
		\code{lambda} overrides this. It is better to supply
		a decreasing sequence of \code{lambda} values than a single (small) value. If not, the program will sort user-defined \code{lambda} sequence in decreasing order automatically.}
		\item{pf}{penalty factor, a vector in length of bn (bn is the total number of groups). Separate penalty weights can be applied to each group to allow
		differential shrinkage. Can be 0 for some groups, which implies
		no shrinkage, and results in that group always being included in the
		model. Default value for each entry is the square-root of the corresponding size of each group (for the lasso, it is 1 for each variable).}
		
		\item{dfmax}{limit the maximum number of groups in the model. Default is \code{bs+1}.}

		\item{pmax}{limit the maximum number of groups ever to be nonzero. For example once a group enters the model, no matter how many times it exits or re-enters model through the path, it will be counted only once. Default is \code{min(dfmax*1.2,bs)}.}

		\item{eps}{convergence termination tolerance. Defaults value is \code{1e-8}.}
		\item{standardize}{logical flag for variable standardization, prior to fitting the model sequence. If \code{TRUE}, x matrix is normalized such that each column is centered and sum squares of each column \eqn{\sum^N_{i=1}x_{ij}^2/N=1}{<Xj,Xj>/N=1}. The coefficients are always returned on the original scale. Default is \code{FALSE}.}
		\item{maxit}{maximum number of inner-layer BMD iterations allowed. Default is 3e8.}
	
}

\details{
The sequence of models implied by \code{lambda} is fit by the IRLS-BMD algorithm. This gives a (grouped) lasso or (grouped) elasticnet regularization path for fitting the Tweedie generalized linear regression paths, by maximizing the corresponding penalized Tweedie log-likelihood. If the \code{group} argument is ignored, the function fits the lasso. Users can tweak the penalty by choosing different \eqn{alpha} and penalty factor.  

For computing speed reason, if models are not converging or running slow, consider increasing \code{eps}, decreasing
\code{nlambda}, or increasing \code{lambda.factor} before increasing
\code{maxit}.
}


\value{
An object with S3 class \code{\link{HDtweedie}}.
		\item{call}{the call that produced this object}
		\item{b0}{intercept sequence of length \code{length(lambda)}}
		\item{beta}{a \code{p*length(lambda)} matrix of coefficients.}
		\item{df}{the number of nonzero groups for each value of
		\code{lambda}.}
		\item{dim}{dimension of coefficient matrix (ices)}
		\item{lambda}{the actual sequence of \code{lambda} values used}
		\item{npasses}{total number of iterations (the most inner loop) summed over all lambda values}
		\item{jerr}{error flag, for warnings and errors, 0 if no error.}
		\item{group}{a vector of consecutive integers describing the grouping of the coefficients.}
}

\author{Wei Qian, Yi Yang and Hui Zou\cr
Maintainer: Wei Qian <weiqian@stat.umn.edu>}
\references{
Qian, W., Yang, Y., Yang, Y. and Zou, H. (2013), ``Tweedie's Compound
    Poisson Model With Grouped Elastic Net,'' submitted to \emph{Journal of Computational and Graphical Statistics}.\cr
}


\seealso{\code{plot.HDtweedie}}
\examples{
# load HDtweedie library
library(HDtweedie)

# load auto data set
data(auto)

# fit the lasso
m0 <- HDtweedie(x=auto$x,y=auto$y,p=1.5)

# define group index
group1 <- c(rep(1,5),rep(2,7),rep(3,4),rep(4:14,each=3),15:21)

# fit the grouped lasso
m1 <- HDtweedie(x=auto$x,y=auto$y,group=group1,p=1.5)

# fit the grouped elastic net
m2 <- HDtweedie(x=auto$x,y=auto$y,group=group1,p=1.5,alpha=0.7)
}
\keyword{models}
\keyword{regression}
