% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testMean.R
\name{testMean}
\alias{testMean}
\title{Testing the equality of two sample mean vectors in high dimension.}
\usage{
testMean(X, Y = NULL, method = "HD", m = 2500, filter = TRUE,
  alpha = 0.05, SX = NULL, SY = NULL)
}
\arguments{
\item{X}{the n x p training data matrix, could be a \code{matrix} or a \code{data.frame} object.}

\item{Y}{the n x p training data matrix, if presented the method will perform
a two-sample test of mean, one-sample test otherwise.
Could be a \code{matrix} or a \code{data.frame} object.}

\item{method}{a string incidating the method for the test. The current available
methods are \code{ALL}, \code{HD}, \code{CQ}, \code{CLX}.}

\item{m}{the number of repetition in the test}

\item{filter}{a logical indicator of the filtering process}

\item{alpha}{the significant level of the test.}

\item{SX}{covariance matrix of X, if not presented it will be estimated from
the input sample.}

\item{SY}{covariance matrix of T, if not presented it will be estimated from
the input sample.}
}
\value{
For method \code{HD}, the function returns two \code{htest} objects for
non-studentized and studentized test respectively.

For method \code{CLX} and \code{CQ}, the function returns an \code{htest} object.

For method \code{ALL}: A list of four \code{htest} objects.

HD refers to arXiv:1406.1939 [math.ST]
}
\description{
Testing the equality of two sample mean vectors in high dimension using different methods.
}
\examples{
data(GO54)
testMean(GO54$X, m = 100, method = "HD")
testMean(GO54$X, GO54$Y, m = 100, method = "ALL")

}
\author{
Tong He
}
