#' HDTSA: High Dimensional Time Series Analysis Tools
#'
#' The purpose of \code{HDTSA} is to address a range of high-dimensional time
#' series problems, which includes solutions to a series of statistical issues,
#' primarily comprising: Procedures for high-dimensional time series analysis
#' including factor analysis proposed by Lam and Yao (2012)
#' <doi:10.1214/12-AOS970> and Chang, Guo and Yao (2015)
#' <doi:10.1016/j.jeconom.2015.03.024>,martingale difference test proposed by
#' Chang, Jiang and Shao (2022) <doi:10.1016/j.jeconom.2022.09.001> in press,
#' principal component analysis proposed by Chang, Guo and Yao (2018)
#' <doi:10.1214/17-AOS1613>, identifying cointegration proposed by Zhang,
#' Robinson and Yao (2019) <doi:10.1080/01621459.2018.1458620>,
#' unit root test proposed by Chang, Cheng and Yao (2021)
#' <doi:10.1093/biomet/asab034>, white noise test proposed by Chang, Yao and
#' Zhou (2017) <doi:10.1093/biomet/asw066>, CP-decomposition for high-dimensional
#' matrix time series proposed by Chang, He, Yang and Yao (2023)
#' <doi:10.1093/jrsssb/qkac011> and Chang, Du, Huang and Yao (2024+), and
#' Statistical inference for high-dimensional spectral density matrix porposed
#' by Chang, Jiang, McElroy and Shao (2023) <doi:10.48550/arXiv.2212.13686>.
#'
#' @name HDTSA-package
#' @useDynLib HDTSA
#' @importFrom Rcpp evalCpp
#' @aliases HDTSA-package HDTSA
#' @author Chen lin, Jinyuan Chang, Qiwei Yao
#' Maintainer: Chen lin<linchen@smail.swufe.edu.cn>
#' @keywords internal
"_PACKAGE"