% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_fonc.R
\name{MRBFSS}
\alias{MRBFSS}
\title{MRBFSS scan procedure}
\usage{
MRBFSS(
  data,
  MC = 999,
  typeI = 0.05,
  nbCPU = 1,
  variable_names = NULL,
  times = NULL,
  initialization,
  permutations
)
}
\arguments{
\item{data}{list of numeric matrices. List of nb_sites (or nb_individuals if the observations are by individuals and not by sites) matrices of the data, the rows correspond to the variables and each column represents an observation time. The times must be the same for each site/individual.}

\item{MC}{numeric. Number of Monte-Carlo permutations to evaluate the statistical significance of the clusters. By default: 999.}

\item{typeI}{numeric. The desired type I error. A cluster will be evaluated as significant if its associated p-value is less than typeI. By default 0.05.}

\item{nbCPU}{numeric. Number of CPU. If nbCPU > 1 parallelization is done. By default: 1.}

\item{variable_names}{character. Names of the variables. By default NULL.}

\item{times}{numeric. Times of observation of the data. By default NULL.}

\item{initialization}{list. Initialization for the scan procedure (see \code{\link{InitScan}} for more details).}

\item{permutations}{matrix. Indices of permutations of the data.}
}
\value{
An object of class ResScanOutputMultiFunct
}
\description{
This function computes the MRBFSS (Multivariate Rank-Based Functional scan statistic).
}
\references{
Camille Frévent and Mohamed-Salem Ahmed and Sophie Dabo-Niang and Michaël Genin. Investigating Spatial Scan Statistics for Multivariate Functional Data. Pre-print <arXiv:2103.14401>.
}
