% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalizing_scan_procedure.R
\name{FinScan}
\alias{FinScan}
\title{Finalization of the scan procedures}
\usage{
FinScan(
  index_clusters_temp,
  index,
  filtering_post,
  type_minimaxi_post,
  mini_post,
  maxi_post,
  nb_sites,
  matrix_clusters,
  radius,
  areas,
  centres,
  pvals,
  maximize = TRUE
)
}
\arguments{
\item{index_clusters_temp}{numeric vector. Indices of the significant clusters.}

\item{index}{numeric vector. Index of concentration for each potential cluster.}

\item{filtering_post}{logical. Is there an a posteriori filtering?}

\item{type_minimaxi_post}{character. Type of minimum and maximum a posteriori: by default "sites/indiv": the mini_post and maxi_post are on the number of sites or individuals in the significant clusters. Other possible values are "area": the minimum and maximum area of the clusters, or "radius": the minimum and maximum radius.}

\item{mini_post}{numeric. A minimum to filter the significant clusters a posteriori (see type_minimaxi_post). The default NULL is for no filtering with a a posteriori minimum.}

\item{maxi_post}{numeric. A maximum to filter the significant clusters a posteriori (see type_minimaxi_post). The default NULL is for no filtering with a a posteriori maximum.}

\item{nb_sites}{numeric. The number of considered sites or individuals.}

\item{matrix_clusters}{matrix. The matrix of potential clusters taking the value 1 at lign i and column j if the cluster j contains the site i, 0 otherwise.}

\item{radius}{numeric vector. The radius of the potential clusters.}

\item{areas}{numeric vector. The areas of the potential clusters.}

\item{centres}{numeric matrix. The coordinates of the centres of each potential cluster.}

\item{pvals}{numeric vector. The pvalue of each potential cluster.}

\item{maximize}{logical. Should the index be maximized? By default TRUE. If FALSE it will be minimized.}
}
\value{
The list of the following elements:
\itemize{
\item pval_clusters: pvalues of the selected clusters.
\item sites_clusters: the indices of the sites of the selected clusters.
\item centres_clusters: the coordinates of the centres of each selected cluster.
\item radius_clusters: the radius of the selected clusters.
\item areas_clusters: the areas of the selected clusters.
}
}
\description{
This function finalizes the scan procedures.
}
