% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simul}
\alias{simul}
\title{Simulate copy number data for a case-control study.}
\usage{
simul(n, nbSNP, probCas, nbSeg, meanSegmentSize, prob, alpha = 15)
}
\arguments{
\item{n}{Number of individuals.}

\item{nbSNP}{Size of the DNA sequence.}

\item{probCas}{Probability to be a case individual.}

\item{nbSeg}{Number of causal segments.}

\item{meanSegmentSize}{The mean size of anormal segment.}

\item{prob}{A 2*2 matrix containing probabilities:

prob[1,1]=probability to have an anomaly to a SNP given the person does not have the disease and the SNP is causal.

prob[1,2]=probability to have an anomaly to a SNP given the person does not have the disease and the SNP is not causal.

prob[2,1]=probability to have an anomaly to a SNP given the person has the disease and the SNP is causal.

prob[2,2]=probability to have an anomaly to a SNP given the person has the disease and the SNP is not causal.}

\item{alpha}{Parameter of the beta(alpha,alpha).}
}
\value{
a list containing: 
\item{data}{A matrix of size n*nbSeg, containing values of the copy-number signal.}
\item{response}{A vector of size n containing the cas/control status.}
\item{causalSNP}{A vector of size nbSeg containing the center of causal segments.}
}
\description{
Simulate copy number data for a case-control study.
}
\examples{
data=simul(50,10000,0.4,10,150,matrix(c(0.1,0.8,0.001,0.001),nrow=2))
}
\author{
Quentin Grimonprez, Serge Iovleff
}

