% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_SBS.R
\name{single_SBS_calibrate}
\alias{single_SBS_calibrate}
\title{Generates threshold \eqn{\pi_T} for Sparsified Binary Segmentation for single change-point detection}
\usage{
single_SBS_calibrate(
  n,
  p,
  N = 100,
  tol = 1/100,
  rescale_variance = TRUE,
  debug = FALSE
)
}
\arguments{
\item{n}{Number of observations}

\item{p}{Number time series}

\item{N}{Number of Monte Carlo samples used}

\item{tol}{False positive probability tolerance}

\item{rescale_variance}{If TRUE, each row of the data is rescaled by a MAD estimate}

\item{debug}{If TRUE, diagnostic prints are provided during execution}
}
\value{
Threshold
}
\description{
R wrapper for function choosing empirical threshold \eqn{\pi_T} using Monte Carlo simulation for single change-point Sparsified Binary Segmentation. More specifically, the function returns the empirical upper tol quantile of CUSUMs over \eqn{p} time series, each of length \eqn{n}, based on \eqn{N} number of runs.
}
\examples{
library(HDCD)
n = 50
p = 50
set.seed(101)

# Simulate threshold
pi_T_squared = single_SBS_calibrate(n=n,p=p,N=100, tol=1/100, rescale_variance = TRUE)
pi_T_squared


# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# Adding a single sparse change-point:
X[1:5, 26:n] = X[1:5, 26:n] +1

# Run SBS
res = single_SBS(X,threshold=sqrt(pi_T_squared),rescale_variance=TRUE)
res$pos
}
