% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_SBS.R
\name{single_SBS}
\alias{single_SBS}
\title{Sparsified Binary Segmentation for single change-point estimation}
\usage{
single_SBS(
  X,
  threshold = NULL,
  rescale_variance = TRUE,
  empirical = FALSE,
  N = 100,
  tol = 1/100,
  debug = FALSE
)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{threshold}{Manually specified value of the threshold \eqn{\pi_T}}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{empirical}{If \code{TRUE}, the threshold is based on Monte Carlo simulation}

\item{N}{If \code{empirical=TRUE}, \code{N} is the number of Monte Carlo samples used}

\item{tol}{If \code{empirical=TRUE}, \code{tol} is the false error probability tolerance}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
A list containing 
  \item{pos}{estimated change-point location}
  \item{maxval}{maximum thresholded and aggregated CUSUM at the estimated change-point position}
}
\description{
R wrapper for C function for single change-point estimation using Sparsified Binary Segmentation \insertCite{cho_multiple-change-point_2015;textual}{HDCD}.
}
\examples{
# Single SBS
library(HDCD)
n = 50
p = 50
set.seed(101)
# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# Adding a single sparse change-point:
X[1:5, 26:n] = X[1:5, 26:n] +1

res = single_SBS(X,threshold=7,rescale_variance=TRUE)
res$pos

# Choose threhsold by Monte Carlo:
res = single_SBS(X,empirical=TRUE,rescale_variance=TRUE)
res$pos
}
\references{
\insertAllCited{}
}
