% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_ESAC.R
\name{single_ESAC}
\alias{single_ESAC}
\title{Efficient Sparsity Adaptive Change-point estimator for a single change-point}
\usage{
single_ESAC(
  X,
  threshold_d = 1.5,
  threshold_s = 1,
  rescale_variance = FALSE,
  debug = FALSE
)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{threshold_d}{Leading constant for \eqn{\lambda(t) \propto r(t)} for \eqn{t= p}}

\item{threshold_s}{Leading constant for \eqn{\lambda(t) \propto r(t)} for \eqn{t\leq \sqrt{p\log n}}.}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
A list containing 
  \item{pos}{estimated change-point location}
  \item{s}{the value of \eqn{t \in \mathcal{T}} at which the sparsity specific score is maximized}
}
\description{
R wrapper for C function implementing ESAC for single change-point estimation, as described in section 3.1 in \insertCite{moen2023efficient;textual}{HDCD}
}
\examples{
library(HDCD)
n = 500
p = 500
set.seed(101)
# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# Adding a single sparse change-point:
X[1:5, 201:500] = X[1:5, 201:500] +1

res = single_ESAC(X,rescale_variance=TRUE)
res$pos

# Manually setting the leading constants for \lambda(t):
# here \lambda(t) = 2 (\sqrt{p \log(n^4)}  + \log (n^4)) for t=p
# and             = 2 (t \log (ep\log n^4 / t^2) + \log(n^4))
res = single_ESAC(X, threshold_d = 2, threshold_s = 2)
res$pos
}
\references{
\insertAllCited{}
}
