% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation_metrics.R
\name{hausdorff}
\alias{hausdorff}
\title{Hausdorff distance between two sets}
\usage{
hausdorff(v1, v2, n)
}
\arguments{
\item{v1}{Vector representing set 1}

\item{v2}{Vector representing set 2}

\item{n}{Sample size (only relevant when either \code{v1} or \code{v2} is \code{NULL})}
}
\value{
The Hausdorff distance between \code{v1} and \code{v2}
}
\description{
Computes the Hausdorff distance between two sets represented as vectors \code{v1} and \code{v2}. If \code{v1 == NULL} and \code{v2 != NULL}, then the largest distance between an element of \code{v1} and the set \eqn{\{1,n\}} is returned, and vice versa. If both vectors are \code{NULL}, \code{0} is returned.
}
\examples{
library(HDCD)
n = 400
true_changepoints = c(50,100)
est_changepoints = c(51,110)
hausdorff(true_changepoints, est_changepoints,n)
hausdorff(true_changepoints, NULL,n)
hausdorff(NULL, est_changepoints,n)
hausdorff(NULL,NULL)
}
