% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asca_plots.R
\name{asca_plots}
\alias{asca_plots}
\alias{loadingplot.asca}
\alias{scoreplot.asca}
\alias{permutationplot}
\title{ASCA Plot Methods}
\usage{
\method{loadingplot}{asca}(object, factor = 1, comps = 1:2, ...)

\method{scoreplot}{asca}(
  object,
  factor = 1,
  comps = 1:2,
  within_level = "all",
  pch.scores = 19,
  pch.projections = 1,
  gr.col = NULL,
  projections = TRUE,
  spider = FALSE,
  ellipsoids,
  confidence,
  xlim,
  ylim,
  xlab,
  ylab,
  legendpos,
  ...
)

permutationplot(object, factor = 1, xlim, xlab = "SSQ", main, ...)
}
\arguments{
\item{object}{\code{asca} object.}

\item{factor}{\code{integer/character} for selecting a model factor. If factor <= 0 or "global",
the PCA of the input is used (negativ factor to include factor level colouring with global PCA).}

\item{comps}{\code{integer} vector of selected components.}

\item{...}{additional arguments to underlying methods.}

\item{within_level}{MSCA parameter for chosing plot level (default = "all").}

\item{pch.scores}{\code{integer} plotting symbol.}

\item{pch.projections}{\code{integer} plotting symbol.}

\item{gr.col}{\code{integer} vector of colours for groups.}

\item{projections}{Include backprojections in score plot (default = TRUE).}

\item{spider}{Draw lines between group centers and backprojections (default = FALSE).}

\item{ellipsoids}{\code{character} "confidence" or "data" ellipsoids for balanced fixed effect models.}

\item{confidence}{\code{numeric} vector of ellipsoid confidences, default = c(0.4, 0.68, 0.95).}

\item{xlim}{\code{numeric} x limits.}

\item{ylim}{\code{numeric} y limits.}

\item{xlab}{\code{character} x label.}

\item{ylab}{\code{character} y label.}

\item{legendpos}{\code{character} position of legend.}

\item{main}{Plot title.}
}
\value{
The plotting routines have no return.
}
\description{
Various plotting procedures for \code{\link{asca}} objects.
}
\details{
Usage of the functions are shown using generics in the examples in \code{\link{asca}}.
Plot routines are available as
\code{scoreplot.asca} and \code{loadingplot.asca}.
}
\references{
\itemize{
\item Smilde, A., Jansen, J., Hoefsloot, H., Lamers,R., Van Der Greef, J., and Timmerman, M.(2005). ANOVA-Simultaneous Component Analysis (ASCA): A new tool for analyzing designed metabolomics data. Bioinformatics, 21(13), 3043–3048.
\item Liland, K.H., Smilde, A., Marini, F., and Næs,T. (2018). Confidence ellipsoids for ASCA models based on multivariate regression theory. Journal of Chemometrics, 32(e2990), 1–13.
\item Martin, M. and Govaerts, B. (2020). LiMM-PCA: Combining ASCA+ and linear mixed models to analyse high-dimensional designed data. Journal of Chemometrics, 34(6), e3232.
}
}
\seealso{
Main methods: \code{\link{asca}}, \code{\link{apca}}, \code{\link{limmpca}}, \code{\link{msca}}, \code{\link{pcanova}}, \code{\link{prc}} and \code{\link{permanova}}.
Workhorse function underpinning most methods: \code{\link{asca_fit}}.
Extraction of results and plotting: \code{\link{asca_results}}, \code{\link{asca_plots}}, \code{\link{pcanova_results}} and \code{\link{pcanova_plots}}
}
