% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{writeHAR}
\alias{writeHAR}
\title{Write HAR object to file}
\usage{
writeHAR(har, file, force = TRUE, ...)
}
\arguments{
\item{har}{A parsed har object output from \code{\link{readHAR}}}

\item{file}{A string indicating the file name to write the HAR data to.}

\item{force}{If the file exists overwrite it. Defaults to TRUE}

\item{...}{addtional arguments}
}
\description{
Write HAR object to file
}
\examples{
\dontrun{
har1 <- readHAR(system.file(package = "HARtools",
                           "exdata", "google.com.har"))
harFile <- tempfile(fileext = ".har")
writeHAR(har1, harFile)
har2 <- readHAR(harFile)
identical(har1, har2)
}
}

