% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HARviewer.R
\name{HARviewer-shiny}
\alias{HARviewer-shiny}
\alias{HARviewerOutput}
\alias{renderHARviewer}
\title{Shiny bindings for HARviewer}
\usage{
HARviewerOutput(outputId, width = "100\%", height = "400px")

renderHARviewer(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to
a string and have \code{'px'} appended. \code{height} will probably
not have an effect; instead, use the \code{height} parameter in
\code{\link{HARviewer}}.}

\item{expr}{An expression that generates a \code{\link{HARviewer}}}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})?
This is useful if you want to save an expression in a variable.}
}
\description{
Shiny bindings for HARviewer
}
\examples{
\dontrun{
library(shiny)
library(HARtools)
har <- readHAR(system.file(package = "HARtools", "exdata",
                           "r-project.org.161028_W2_11MA.har"))
hv <- HARviewer(har)

shinyApp(
  ui = fluidPage(
    HARviewerOutput("myHAR")
  ),
  server = function(input, output) {
    output$myHAR <- renderHARviewer(hv)
  }
)
}
}

