package de.fhg.iais.kd.djm;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class DistributedJobManagement {

	
	private static Logger logger = Logger.getLogger(DistributedJobManagement.class);
	
	private static ClientConnectionManager clientConnectionManager;
	protected static boolean shutdown = false;
	protected static ServerSocket serverSocket;

	protected static HashMap<String[], SSHClient> sshConnections = new HashMap<String[], SSHClient>(); // mapping
																							// ip, username
																							// to
																							// MySSh
																							// connection
	protected static HashMap<Integer, JobDescription> jobs = new HashMap<Integer, JobDescription>(); // Mapping
																									// jobID
																									// to
																									// JobDescription
	protected static HashMap<String, ArrayList<Integer>> userJobs = new HashMap<String, ArrayList<Integer>>(); // mapping
																											// user
																											// to
																											// his
																											// running
																											// jobs

	private static int idCount = -1;

	public static int getNewID() {
		idCount++;
		return idCount;
	}

	public void startup(int port) throws IOException {
		PropertyConfigurator.configureAndWatch( "log4j.properties", 60*1000 );
		  
		logger.debug("starting up...");
		
		clientConnectionManager = new ClientConnectionManager();

		this.openServerSocket(port);
		clientConnectionManager.waitForClientConnections();
	}

	public void openServerSocket(int port) throws IOException {

		logger.debug("opening server socket on port " + port + "...");
		
		serverSocket = new ServerSocket(port);
		
	}

}
