% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_multiple_kernel_search.R
\name{resultsMultipleKernelGreedySearch}
\alias{resultsMultipleKernelGreedySearch}
\title{Returns the results (thus far) of the greedy design search for multiple kernels}
\usage{
resultsMultipleKernelGreedySearch(obj, max_vectors = 9, form = "one_zero")
}
\arguments{
\item{obj}{The \code{greedy_multiple_kernel_experimental_design} object that is currently running the search}

\item{max_vectors}{The number of design vectors you wish to return. \code{NULL} returns all of them. 
This is not recommended as returning over 1,000 vectors is time-intensive. The default is 9.}

\item{form}{Which form should it be in? The default is \code{one_zero} for 1/0's or \code{pos_one_min_one} for +1/-1's.}
}
\description{
Returns the results (thus far) of the greedy design search for multiple kernels
}
\examples{
 \dontrun{
	library(MASS)
	data(Boston)
 #pretend the Boston data was an experiment setting 
	#first pull out the covariates
 X = Boston[, 1 : 13]
 #begin the greedy design search
	ged = initGreedyMultipleKernelExperimentalDesignObject(X, 
		max_designs = 1000, num_cores = 3, kernel_names = c("mahalanobis", "gaussian"))
	#wait
	res = resultsMultipleKernelGreedySearch(ged, max_vectors = 2)
	design = res$ending_indicTs[, 1] #ordered already by best-->worst
 design
	#how far have we come of the 1000 we set out to do?
	ged
	#we can cut it here
	stopSearch(ged)
	}
}
\author{
Adam Kapelner
}
