% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gurobi_numerical_optimization_search.R
\name{initGurobiNumericalOptimizationExperimentalDesignObject}
\alias{initGurobiNumericalOptimizationExperimentalDesignObject}
\title{This method creates an object of type optimal_experimental_design and will immediately initiate
a search through $1_{T}$ space.}
\usage{
initGurobiNumericalOptimizationExperimentalDesignObject(X, num_cores = 1,
  time_limit_min = 5, node_limit = NULL, max_solutions = 10,
  verbose = TRUE, log_file = "")
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}

\item{time_limit_min}{The maximum amount of time the optimizer can run for in minutes. The default is \code{5}.}

\item{node_limit}{The maximum number of nodes Gurobi should explore. Default is \code{NULL} for no limit.}

\item{max_solutions}{The maximum number of solutions Gurobi should retain (if possible given the time limit and constraint of the 
node limit). The default is \code{NULL} for Gurobi's default of 10.}

\item{verbose}{Should Gurobi print its log to screen? Default is \code{TRUE}.}

\item{log_file}{Log filename for Gurobi e.g. \code{my_log.txt}. Default is \code{""} for no file log.}
}
\value{
An object of type \code{optimal_experimental_design_search} which can be further operated upon
}
\description{
This method creates an object of type optimal_experimental_design and will immediately initiate
a search through $1_{T}$ space.
}
\author{
Adam Kapelner and Bracha Blau
}
