% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_search.R
\name{initOptimalExperimentalDesignObject}
\alias{initOptimalExperimentalDesignObject}
\title{This method creates an object of type optimal_experimental_design and will immediately initiate
a search through $1_{T}$ space.}
\usage{
initOptimalExperimentalDesignObject(X, objective = "abs_sum_diff",
  wait = FALSE, start = TRUE, num_cores = 1)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{objective}{The objective function to use when greedily searching design space. This is a string
"\code{abs_sum_diff}" (default) or "\code{mahal_dist}."}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
deafult is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}
}
\value{
An object of type \code{optimal_experimental_design_search} which can be further operated upon
}
\description{
This method creates an object of type optimal_experimental_design and will immediately initiate
a search through $1_{T}$ space.
}
\author{
Adam Kapelner
}
