% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph.R
\name{graph_invar}
\alias{graph_invar}
\title{Graph Invar}
\usage{
graph_invar(x, sigmaHat, thetaHat, invar = c("connectivity", "longest_chain",
  "max_degree", "largest_clique", "chromatic_number", "num_singletons",
  "girth"), numB = 1000, alpha = 0.05)
}
\arguments{
\item{x}{A sample of data}

\item{sigmaHat}{A sample covariance matrix for \code{x}}

\item{thetaHat}{A sample precision matrix estimated from \code{sigmaHat}}

\item{invar}{The monotone graph invariant to examine}

\item{numB}{The number of bootstrap samples to take Default: 1000}

\item{alpha}{The significance level for the confidence interval Default: 0.05}
}
\value{
A confidence intveral for the value of \code{invar} with sig. level \code{alpha}
}
\description{
Computes the confidence interval for a numeric invariant on an
estimated conditional independence graph.
}
\examples{

data(Xs,cov.hat,t.hat)
graph_invar(x=Xs,sigmaHat=cov.hat,thetaHat=t.hat,invar="conn")

}

