% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern35_scaledim}
\alias{matern35_scaledim}
\alias{d_matern35_scaledim}
\alias{d_matern45_scaledim}
\title{Matern covariance function, smoothess = 3.5, different range parameter for each dimension}
\usage{
matern35_scaledim(covparms, locs)

d_matern35_scaledim(covparms, locs)

d_matern45_scaledim(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range_1, ..., range_d, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs is a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, range_1, ..., range_d, nugget), return the square matrix of
all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_matern35_scaledim}: Derivatives with respect to parameters

\item \code{d_matern45_scaledim}: Derivatives with respect to parameters
}}

\section{Parameterization}{

The covariance parameter vector is (variance, range_1, ..., range_d, nugget).
The covariance function is parameterized as
\deqn{ M(x,y) = \sigma^2 ( \sum_{j=0}^3 c_j || D^{-1}(x - y) ||^j  ) exp( - || D^{-1}(x - y) || ) }
where c_0 = 1, c_1 = 1, c_2 = 2/5, c_3 = 1/15.
where D is a diagonal matrix with (range_1, ..., range_d) on the diagonals.
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

