% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_sphere_time}
\alias{matern_sphere_time}
\title{Isotropic Matern covariance function on sphere-time}
\usage{
matern_sphere_time(covparms, lonlattime)
}
\arguments{
\item{covparms}{A vector giving positive-valued covariance parameters
in the form (variance, spatial range, temporal range, smoothness, nugget)}

\item{lonlattime}{A matrix with \code{n} rows and one column with longitudes in (-180,180),
one column of latitudes in (-90,90), and one column of times.
Each row of locs describes a point on the sphere-time domain.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{lonlattime[i,]} and
\code{lonlattime[j,]}.
}
\description{
From a matrix of longitudes, latitudes, and times and a vector covariance parameters of the form
(variance, spatial range, temporal range, smoothness, nugget), return the square matrix of
all pairwise covariances.
}
\section{Matern on Sphere-Time Domain}{

The function first calculates the (x,y,z) 3D spatial coordinates, and scales the
spatial coordinates by the spatial range and the temporal coordinates by
the temporal range. Then the scaled coordinates are input into
\code{maternIsotropic}. This means that we construct
covariances on the sphere-time by embedding the sphere-time domain in a 4D space, with a
different range parameter for the three spatial dimensions versus the one
temporal dimension. There has been some
concern expressed in the literature that embedding points on the sphere into
a 3D domain may cause distortions.
The source and nature of such distortions has never been articulated,
and to date, no such distortions have been documented. Guinness and
Fuentes (2016) argue that 3D embeddings produce reasonable models for data on spheres.
}

