% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{fast_Gp_sim}
\alias{fast_Gp_sim}
\title{Approximate GP simulation}
\usage{
fast_Gp_sim(covparms, covfun_name = "matern_isotropic", locs, m = 30)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{One of "matern_isotropic", "matern_space_time", "matern_sphere", 
or "matern_sphere_time".
"matern_isotropic" and "matern_sphere" have four covariance parameters, 
(variance, range, smoothness, nugget), while "matern_space_time" and 
"matern_sphere_time" have five,
(variance, spatial range, temporal range, smoothness, nugget). 
For more details, see the documentation 
for each of the covariance functions by typing, for example, ?matern_isotropic
or ?matern_sphere_time.}

\item{locs}{matrix of locations. Row \code{i} of locs specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{m}{Number of nearest neighbors to use in approximation}
}
\value{
vector of simulated values
}
\description{
Calculates an approximation to the inverse Cholesky
factor of the covariance matrix using Vecchia's approximation,
then the simulation is produced by solving a linear system
with a vector of uncorrelated standard normals
}
\examples{
locs <- as.matrix( expand.grid( (1:100)/100, (1:100)/100 ) )
y <- fast_Gp_sim(c(4,0.2,0.5,0), "matern_isotropic",  locs, 30 )
fields::image.plot( matrix(y,100,100) )
}
