% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbor_functions.R
\name{find_ordered_nn}
\alias{find_ordered_nn}
\title{Find ordered nearest neighbors.}
\usage{
find_ordered_nn(locs, m, lonlat = FALSE, space_time = FALSE,
  st_scale = NULL)
}
\arguments{
\item{locs}{A matrix of locations. Each row of \code{locs} contains a location, which can
be a point in Euclidean space R^d, a point in space-time R^d x T, 
a longitude and latitude (in degrees) giving a point on the sphere, 
or a longitude, latitude, and time giving a point in the sphere-time domain.}

\item{m}{Number of neighbors to return}

\item{lonlat}{TRUE/FALSE whether locations are longitudes and latitudes.}

\item{space_time}{TRUE if locations are euclidean space-time locations, 
FALSE otherwise. If set to TRUE, temporal dimension is ignored.}

\item{st_scale}{two-vector giving the amount by which the spatial
and temporal coordinates are scaled. If \code{NULL}, the function
uses the locations to automatically select a scaling.
If set to FALSE, temporal dimension treated as another spatial dimension (not recommended).}
}
\value{
An matrix containing the indices of the neighbors. Row \code{i} of the
returned matrix contains the indices of the nearest \code{m}
locations to the \code{i}'th location. Indices are ordered within a
row to be increasing in distance. By convention, we consider a location
to neighbor itself, so the first entry of row \code{i} is \code{i}, the
second entry is the index of the nearest location, and so on. Because each
location neighbors itself, the returned matrix has \code{m+1} columns.
}
\description{
Given a matrix of reordered locations, find the \code{m} nearest neighbors
to each location, subject to the neighbors coming
previously in the ordering. The algorithm uses the kdtree
algorithm in the FNN package, adapted to the setting
where the nearest neighbors must come from previous
in the ordering.
}
\examples{
locs <- as.matrix( expand.grid( (1:40)/40, (1:40)/40 ) )     # grid of locations
ord <- order_maxmin(locs)                                     # calculate an ordering
locsord <- locs[ord,]                                        # reorder locations
m <- 20
NNarray <- find_ordered_nn(locsord,20)             # find ordered nearest 20 neighbors
ind <- 100
# plot all locations in gray, first ind locations in black,
# ind location with magenta circle, m neighhbors with blue circle
plot( locs[,1], locs[,2], pch = 16, col = "gray" )
points( locsord[1:ind,1], locsord[1:ind,2], pch = 16 )
points( locsord[ind,1], locsord[ind,2], col = "magenta", cex = 1.5 )
points( locsord[NNarray[ind,2:(m+1)],1], locsord[NNarray[ind,2:(m+1)],2], col = "blue", cex = 1.5 )
}
