% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mw.r
\name{mwPlot}
\alias{mwPlot}
\title{R function for visually displaying Mann-Whitney test's results}
\usage{
mwPlot(
  x,
  y,
  xlabl = "x",
  ylabl = "y",
  strip = FALSE,
  notch = FALSE,
  omm = FALSE,
  outl = TRUE,
  HL = FALSE
)
}
\arguments{
\item{x}{Object storing the values of the first group being compared.}

\item{y}{Object storing either the values of the second group being compared or a grouping
variable with 2 levels.}

\item{xlabl}{If y is not a grouping variable, user may want to specify here the name of the x
group that will show up in the returned boxplots (default is "x").}

\item{ylabl}{If y is not a grouping variable, user may want to specify here the name of the y
group that will show up in the returned boxplots (default is "y").}

\item{strip}{Logical value which takes FALSE (by default) or TRUE if the user wants jittered
points to represent individual values.}

\item{notch}{Logical value which takes FALSE (by default) or TRUE if user does not or do want to
have notched boxplots in the final display, respectively; it is worth noting that overlapping
of notches indicates a not significant difference at about 95 percent confidence.}

\item{omm}{It stands for overall mean and median; takes FALSE (by default) or TRUE if user
wants the mean and median of the overall sample plotted in the chart (as a dashed RED line and
dotted BLUE line respectively).}

\item{outl}{Logical value which takes FALSE or TRUE (by default) if users want the boxplots to
display outlying values.}

\item{HL}{Logical value that takes TRUE or FALSE (default) if the user wants to display the
distribution of the pairwise differences between the values of the two samples being compared;
the median of that distribution is the Hodges-Lehmann estimator.}
}
\description{
The function  allows to perform Mann-Whitney test, and to display the test's results in a plot
along with two boxplots. For information about the test, and on what it is actually testing, see
for instance the interesting article by R M Conroy, "What hypotheses do "nonparametric" two-group
tests actually test?", in The Stata Journal 12 (2012): 1-9.\cr
}
\details{
The returned boxplots display the
distribution of the values of the two samples, and jittered points represent the individual
observations.

At the bottom of the chart, a subtitle arranged on three lines reports relevant
statistics:\cr -test statistic (namely, U) and the associated z and p value;\cr -Probability of
Superiority value (which can be interpreted as an effect-size measure, as discussed in:
https://nickredfern.wordpress.com/2011/05/12/the-mann-whitney-u-test/);\cr -another measure of
effect size, namely r (see
https://stats.stackexchange.com/questions/124501/mann-whitney-u-test-confidence-interval-for-effect-size),
whose thresholds are indicated in the last line of the plot's subtitle.\cr

The function may also
return a density plot (coupled with a rug plot at the bottom of the same chart) that displays the
distribution of the pairwise differences between the values of the two samples being compared.
The median of this distribution (which is represented by a blue reference line in the same chart)
corresponds to the Hodges-Lehmann estimator.
}
\examples{
#create a toy dataset
mydata <- data.frame(values=c(rnorm(30, 100,10),rnorm(30, 80,10)),
group = as.factor(gl(2, 30, labels = c("A", "B"))))

# performs the test, displays the test's result, including jittered points, notches,
#overall median and mean, and the Hodges-Lehmann estimator
mwPlot(x=mydata$values, y=mydata$group, strip=TRUE, omm=TRUE, notch=TRUE, HL=TRUE)

}
\keyword{mwPlot}
