% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssa.plot.R
\name{ssa.plot}
\alias{ssa.plot}
\title{Simple plotting of ssa output}
\usage{
ssa.plot(out = stop("requires simulation output object"),
  file = "ssaplot", by = 1, plot.from = 2,
  plot.to = dim(out$data)[2], plot.by = 1, show.title = TRUE,
  show.legend = TRUE)
}
\arguments{
\item{out}{data object returned from \code{\link[=ssa]{ssa()}}.}

\item{file}{name of the output file (only applicable if
\code{plot.device!="x11"}.}

\item{by}{time increment in the plotted time series}

\item{plot.from}{first population to plot the time series for (see note)}

\item{plot.to}{last population to plot the time series for (see note)}

\item{plot.by}{increment in the sequence of populations to plot the time
series for (see note)}

\item{show.title}{boolean object indicating if the plot should display a
title}

\item{show.legend}{boolean object indicating if the legend is displayed}
}
\description{
Provides basic functionally for simple and quick time series plot of
simulation output from \code{\link[=ssa]{ssa()}}.
}
\note{
The options \code{by}, \code{plot.from}, \code{plot.to}, and
\code{plot.by} can be used to plot a sparser sequence of data points. To
plot the population sizes using a larger time interval the \code{by} option
can be set, e.g. to plot only every 10th time point \code{by=10}. To plot
only specific populations the \code{plot.from}, \code{plot.to}, and
\code{plot.by} options can be set to subset the state vector. Note that the
indexing of the populations is based on the \eqn{(t,\mathbf{X})}{(t,X)}
vector, i.e. the first column is the time vector while the first population
is index by 2 and the last population by \eqn{N+1}. Display of a plot title
above the plot and legend is optional (and are set with the arguments
show.title and show.legend. Above the plot panel miscellaneous information
for the simulation are displayed, i.e. method, elapsed wall time, number of
time steps executed, and the number of time steps per data point.
}
\examples{
## Define the Kermack-McKendrick SIR model and run once using the Direct method
parms <- c(beta=.001, gamma=.100)
x0 <- c(S=500, I=1, R=0)                         # Initial state vector
nu <- matrix(c(-1,0,1,-1,0,1),nrow=3,byrow=TRUE) # State-change matrix
a  <- c("beta*S*I", "gamma*I")                   # Propensity vector
tf <- 100                                        # Final time
simName <- "Kermack-McKendrick SIR"
out <- ssa(x0,a,nu,parms,tf,method="D",simName,verbose=TRUE,consoleInterval=1)

## Basic ssa plot
ssa.plot(out)

# Plot only the infectious class
ssa.plot(out,plot.from=3,plot.to=3)

}
\seealso{
\link{GillespieSSA-package}, \code{\link[=ssa]{ssa()}}
}
\keyword{datagen}
\keyword{device}
\keyword{hplot}
\keyword{misc}
\keyword{ts}
\keyword{utilities}
