% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghfd_read_file.R
\name{ghfd_read_file}
\alias{ghfd_read_file}
\title{Reads zip file downloaded from Bovespa ftp}
\usage{
ghfd_read_file(out.file, my.assets = NULL, first.time = "10:00:00",
  last.time = "17:00:00", type.output = "agg", agg.diff = "15 min")
}
\arguments{
\item{out.file}{Name of zip file}

\item{my.assets}{The tickers (symbols) of the derised assets to import data (e.g. c('PETR4', 'VALE5'))}

\item{first.time}{The first intraday period to import the data. All trades before this time of day are ignored. As character, e.g. '10:00:00'.}

\item{last.time}{The last intraday period to import the data. All trades after this time of day are ignored. As character, e.g. '18:00:00'.}

\item{type.output}{Defines the type of output of the data. The choice 'agg' outputs aggregated data for time intervals defined in agg.diff.
The choice 'raw' outputs the raw, tick by tick, data from the zip files.}

\item{agg.diff}{The time interval used in the aggregation of data. Only used for type.output='agg'. It should contain a integer followed by a time unit ('sec' or 'secs', 'min' or 'mins', 'hour' or 'hours', 'day' or 'days').
Example: agg.diff = '15 mins', agg.diff = '1 hour'.}
}
\value{
A dataframe with the raw (tick by tick) dataset
}
\description{
Reads zip file downloaded from Bovespa ftp
}
\examples{

my.assets <- c('ABEVA20', 'PETRL78')

## getting data from local file (in practice it would be downloaded from ftp)
out.file <- system.file("extdata", 'NEG_OPCOES_20151126.zip', package = "GetHFData")

df.out <- ghfd_read_file(out.file, my.assets)
print(head(df.out))
}

