% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNA_seq.R
\name{diff_RNA_ucsc}
\alias{diff_RNA_ucsc}
\title{Do difference analysis of RNA-seq data downloaded from ucsc}
\usage{
diff_RNA_ucsc(ucscfile, ...)
}
\arguments{
\item{ucscfile}{a dataframe or numeric matrix of ucsc RNA-seq data}

\item{...}{additional parameters}
}
\description{
Do difference analysis of RNA-seq data downloaded from ucsc
}
\examples{
\dontrun{
ucscfile <- data.table::fread("TCGA-BRCA.htseq_counts.tsv.gz")
group <- sample(c("grp1", "grp2"), ncol(ucscfile) - 1, replace = TRUE)
result <- diff_RNA_ucsc(ucscfile, group = group)
}
}
