% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\name{loessFilter}
\alias{loessFilter}
\title{Filter to remove outliers in defined twilight times based on smoother function}
\usage{
loessFilter(tFirst, tSecond, type, twl, k = 3, plot = TRUE)
}
\arguments{
\item{tFirst}{vector of sunrise/sunset times (e.g. 2008-12-01 08:30).}

\item{tSecond}{vector of of sunrise/sunset times (e.g. 2008-12-01 17:30).}

\item{type}{vector of either 1 or 2, defining \code{tFirst} as sunrise or sunset respectively.}

\item{twl}{data.frame containing twilights and at least \code{tFirst}, \code{tSecond} and \code{type} (alternatively give each parameter separately).}

\item{k}{a measure of how many interquartile ranges to take before saying
that a particular twilight event is an outlier}

\item{plot}{codelogical, if TRUE a plot indicating the filtered times will
be produced.}
}
\value{
Logical \code{vector} matching positions that pass the filter.
}
\description{
This filter defines outliers based on residuals from a local polynomial
regression fitting provcess (\code{\link{loess}}).
}
\author{
Simeon Lisovski & Eldar Rakhimberdiev
}

