% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\docType{data}
\name{calib1}
\alias{calib}
\alias{calib1}
\alias{calib2}
\title{Example data for calibration: Light intensities and twilight events}
\description{
Light intensity measurements over time (calib1) recorded at the rooftop of
the Swiss Ornithological Institute (Lon: 8.0, Lat: 47.01). Defined twilight
events from calib1 (calib2). These data serve as an example for calculating
the sun elevation angle of an additional data set, which is subsequently
used to calibrate the focal dataset.
}
\examples{
data(calib2)
 calib2$tFirst <- as.POSIXct(calib2$tFirst, tz = "GMT")
 calib2$tSecond <- as.POSIXct(calib2$tSecond, tz = "GMT")
getElevation(calib2, known.coord = c(8,47.01))
}
\references{
Lisovski, S., Hewson, C.M, Klaassen, R.H.G., Korner-Nievergelt,
F., Kristensen, M.W & Hahn, S. (2012) Geolocation by light: Accuracy and
precision affected by environmental factors. \emph{Methods in Ecology and
Evolution}, DOI: 10.1111/j.2041-210X.2012.00185.x.
}

