% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searcher_efficiency_functions.R
\name{aicc.pkmSet}
\alias{aicc.pkmSet}
\title{Create the AICc tables for a set of searcher efficiency models}
\usage{
\method{aicc}{pkmSet}(x, ..., quiet = FALSE, app = FALSE)
}
\arguments{
\item{x}{Set of searcher efficiency models fit to the same
observations}

\item{...}{further arguments passed to or from other methods}

\item{quiet}{Logical indicating if messages should be printed}

\item{app}{Logical indicating if the table should have the app model names}
}
\value{
AICc table
}
\description{
Generates model comparison tables based on AICc values for
  a set of pk models generated by \code{\link{pkmSet}}
}
\examples{
  data(wind_RP)
  mod <- pkmSet(formula_p = p ~ Season, formula_k = k ~ Season, data = wind_RP$SE)
 aicc(mod)

}
