% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searcher_efficiency_functions.R
\name{pkLogLik}
\alias{pkLogLik}
\title{Calculate the negative log-likelihood of a searcher efficiency model}
\usage{
pkLogLik(misses, foundOn, beta, nbeta_p, cellByCarc, maxmisses, cellMM,
  kFixed = NULL)
}
\arguments{
\item{misses}{Number of searches when carcass was present but
not found.}

\item{foundOn}{Search on which carcass was found.}

\item{beta}{Parameters to be optimized.}

\item{nbeta_p}{Number of parameters associated with p.}

\item{cellByCarc}{Which cell each observation belongs to.}

\item{maxmisses}{Maximum possible number of misses for a carcass.}

\item{cellMM}{Combined pk model matrix.}

\item{kFixed}{Value of k if fixed.}
}
\value{
Negative log likelihood of the observations, given the parameters.
}
\description{
The function used to calculate the negative-loglikelihood of
  a given searcher efficiency model (\code{\link{pkm}}) with a given data
  set
}
