\name{check.marker-class}
\docType{class}
\alias{check.marker-class}
\alias{summary, check.marker-method}
\alias{plot, check.marker-method}

\title{Class "check.marker"}
\description{This class contains results of genotypic quality control. This is 
an list object, usually generated by \code{\link{check.marker}}.
}
\section{Names}{
\item{ok}{Markers which passed all criteria}
\item{nohwe}{Markers which did not pass HWE check}
\item{Pex.nohwe}{Exact HWE P-values for markers which did not pass HWE check}
\item{nocall}{Markers with call rate < specified callrate}
\item{nomaf}{Markers with MAF < specified maf}
\item{redundant}{Redundant markers}
\item{details.redundancy}{List with details on redundant markers (reference-marker <-> redundant-markers)}
\item{call}{List with details on call: call, name (of marker), map, chromosome}
%\describe{
%	}
}
%\section{Extends}{
%}
\section{Methods}{
  \describe{
    \item{summary}{\code{signature(object = "check.marker")}: 
	gives a cross table summrising how many markers did not 
	pass because of this or that criteria
	 }
    \item{plot}{\code{signature(object = "check.marker")}: 
	Plots summary of genotypic data QC
	 }
  }
}
%\references{}
\author{Yurii Aulchenko}
%\note{}
\seealso{
\code{\link{check.marker}},
\code{\link{summary.check.marker}},
\code{\link{redundant}},
\code{\link{plot.check.marker}}
}
\examples{
data(srdta)
mc <- check.marker(data=srdta@gtdata[,1:100],call=0.98,maf=0.01,minconcordance=0.9,fdr=.1)
class(mc)
names(mc)
names(mc$call)
mc$nohwe
mc$Pex.nohwe
summary(mc)
plot(mc)
}
\keyword{classes}

