% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylotree_class.R
\name{B_to_phylotree}
\alias{B_to_phylotree}
\title{Create a \code{Phylotree} object from a \code{B} matrix.}
\usage{
B_to_phylotree(B, labels = NA)
}
\arguments{
\item{B}{A square matrix that represents the phylogenetic tree.}

\item{labels}{An optional vector containing the tags of the genes in the phylogenetic tree. \code{NA} by default.}
}
\value{
A \code{Phylotree} class object.
}
\description{
This function creates a \code{Phylotree} class object from a \code{B} matrix.
}
\examples{
# Create a B matrix instance
# composed by 10 subpopulations of
# clones
B <- create_instance(
       n = 10, 
       m = 4, 
       k = 1, 
       selection = "neutral")$B

# Create a new 'Phylotree' object
# on the basis of the B matrix
phylotree <- B_to_phylotree(B = B)

# Generate the tags for the genes of
# the phyogenetic tree
tags <- LETTERS[1:nrow(B)]

# Create a new 'Phylotree' object
# on the basis of the B matrix and
# the list of tags
phylotree_tags <- B_to_phylotree(
                    B = B, 
                    labels = tags)
}
