% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R
\name{deviance.GeDS}
\alias{deviance.GeDS}
\title{Deviance method for GeDS objects}
\usage{
\method{deviance}{GeDS}(object, n = 3L, ...)
}
\arguments{
\item{object}{the \code{\link{GeDS-class}} object from which the deviance should be extracted.}

\item{n}{integer value (2, 3 or 4) specifying the order (\eqn{=} degree \eqn{+ 1}) of the GeDS fit
whose deviance should be extracted.
By default equal to \code{3L}.
Non-integer values will be passed to the function \code{\link{as.integer}}.}

\item{...}{potentially further arguments (required by the definition of the generic function).
They will be ignored, but with a warning.}
}
\value{
A numeric value corresponding to the  deviance of the selected GeDS fit.
}
\description{
Method for the function \code{\link[stats]{deviance}} that allows the user to extract  the value
of the deviance corresponding to a selected GeDS fit from a \code{\link{GeDS-Class}} object.
}
\details{
This is a method for the function \code{\link[stats]{deviance}}.
As \code{\link{GeDS-class}} objects contain three different fits (linear, quadratic and cubic),
it is possible
to specify the order of the GeDS fit for which the deviance is required via the input argument \code{n}.
}
\seealso{
\code{\link[stats]{deviance}} for the standard definition; \code{\link{GGeDS}} for examples.
}
