% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWexPrec_lib.r
\name{infer.dep.amount}
\alias{infer.dep.amount}
\title{infer.dep.amount}
\usage{
infer.dep.amount(
  P.mat,
  isPeriod,
  infer.mat.omega.out,
  nLag,
  th,
  parMargin,
  typeMargin,
  nChainFit,
  isMAR,
  copulaInt,
  isParallel
)
}
\arguments{
\item{P.mat}{precipitation matrix}

\item{isPeriod}{vector of logical n x 1 indicating the days concerned by a 3-month period}

\item{infer.mat.omega.out}{output of \code{\link{infer.mat.omega}}}

\item{nLag}{order of he Markov chain for the transitions between dry and wet states (=2 by default)}

\item{th}{threshold above which we consider that a day is wet (e.g. 0.2 mm)}

\item{parMargin}{parameters of the margins 2 x 3}

\item{typeMargin}{'EGPD' (Extended GPD) or 'mixExp' (Mixture of Exponentials). 'EGPD' by default}

\item{nChainFit}{integer, length of the runs used during the fitting procedure. =100000 by default}

\item{isMAR}{logical value, do we apply a Autoregressive Multivariate Autoregressive model (order 1) =TRUE by default}

\item{copulaInt}{'Gaussian' or 'Student': type of dependence for amounts (='Student' by default)}

\item{isParallel}{logical: indicate computation in parallel or not (easier for debugging)}
}
\value{
\item{list}{list of estimates (e.g., M0, dfStudent)}
}
\description{
estimate parameters which control the spatial dependence between intensities using a copula
}
\author{
Guillaume Evin
}
