% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.index.lsn.data.R
\name{order.index.lsn.data}
\alias{order.index.lsn.data}
\title{Order Index Lesion Data}
\usage{
order.index.lsn.data(lsn.data)
}
\arguments{
\item{lsn.data}{data.frame with lesion data prepared by the user in a GRIN compatible format. The data.frame should has five columns that include "ID" which is a column with id of the patient affected by the lesion, "chrom" which is the chromosome on which the lesion is located, "loc.start" which is the lesion start position, "loc.end" the lesion end position and "lsn.type" which is the lesion type for example gain, loss, mutation, fusion, etc...}
}
\value{
A list with the following components:
\item{lsn.data}{Input lesion data}
\item{lsn.index}{data.frame with row start and row end for each type of lesions affecting each subject on a certain chromosome. For example, if a certain patient is affected by 1 deletion on chromosome 5, row start wil be equal to row end for loss on chromosome 5. However, if the patient is affected by 4 deletions, difference between row.start and row.end will be 3.}
}
\description{
This function order and index lesion data by lesion type, the chromosome on which the lesion is located , and subject.
}
\examples{
data(lesion.data)

ordered.lsn=order.index.lsn.data(lesion.data)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
