% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{nutrient_maps}
\alias{nutrient_maps}
\title{Map average load output by source}
\usage{
nutrient_maps(green_file, sh_file, plot.type, style, legend_position = 1)
}
\arguments{
\item{green_file}{data frame of GREEN model results from green_shares()
function. Nutrient Load by source apportionment of nutrient for each year
and catchments.}

\item{sh_file}{sf object. The spatial information of the basin.}

\item{plot.type}{character. Alternatives of the map: “gr1”: output load
(kt/y) by source; “gr2”: Total Load, log10 (kt/y); “gr3”: Total Load
by km2 (kt/year/km2).}

\item{style}{charater. The style of the plot.}

\item{legend_position}{numeric. Legend position: 1 (default): "right",
"bottom"; 2: "left", "up"; 3: "right", "bottom"; 4: "right", "up".}
}
\value{
No return value, called for the side effect of drawing a plot
}
\description{
Creates maps showing basin output total or by source loads
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
data(sh_file)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# years in which the model should be executed
loc_years <- 1990:2018
# Computing the source apportionment
basin_sa <- green_shares(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, loc_years)
# Basin Output Load  Maps by source
Lpos <- 1
nutrient_maps(basin_sa, sh_file, plot.type = "gr1", style = "log10", legend_position = Lpos)
# Basin Output Specific Load  Maps
Lpos <- 1
nutrient_maps(basin_sa, sh_file, plot.type = "gr2", style = "log10", legend_position = Lpos)
# Basin Output Specific Load by km2 Maps
Lpos <- 1
nutrient_maps(basin_sa, sh_file, plot.type = "gr3", style = "fisher", legend_position = Lpos)
}

}
