% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichol.R
\name{ichol}
\alias{ichol}
\title{Wrapper for incomplete Cholesky decomposition}
\usage{
ichol(M, S = NULL)
}
\arguments{
\item{M}{the matrix to be decomposed}

\item{S}{sparsity pattern matrix given}
}
\value{
the incomplete Cholesky factor in the sparse format
}
\description{
Wrapper for incomplete Cholesky decomposition
}
\examples{
A = matrix(runif(25), ncol = 5)
A = t(A) * A + 2 * Matrix::Diagonal(5)
S = Matrix::Matrix(c(rep(1, 5), c(0, 1, 1, 0, 0), c(0, 0, 1, 0, 1),
c(0, 0, 0, 1, 0), c(0, 0, 0, 0, 1)), ncol = 5, byrow = TRUE)
I1 = ichol(A, S)
I2 = ichol(A * S)

}
