% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_laplace_NR.R
\name{vecchia_laplace_likelihood_from_posterior}
\alias{vecchia_laplace_likelihood_from_posterior}
\title{Wrapper for VL version of vecchia_likelihood}
\usage{
vecchia_laplace_likelihood_from_posterior(
  z,
  posterior,
  vecchia.approx,
  likelihood_model,
  covparms,
  likparms = list(alpha = 2, sigma = sqrt(0.1)),
  covmodel = "matern",
  max.iter = 50,
  convg = 1e-05,
  return_all = FALSE,
  y_init = NA,
  prior_mean = rep(0, length(z)),
  vecchia.approx.IW = NA
)
}
\arguments{
\item{z}{an array of real numbers representing observations}

\item{posterior}{posterior distribution obtained from calculate_posterior_VL()}

\item{vecchia.approx}{a vecchia object as generated by vecchia_specify()}

\item{likelihood_model}{text describing likelihood model to be used for observations}

\item{covparms}{covariance parameters as a vector}

\item{likparms}{likelihood parameters for the likelihood_model, as a list}

\item{covmodel}{describes the covariance model, "matern" by default}

\item{max.iter}{maximum iterations to perform}

\item{convg}{convergence criteria.  End iterations if the Newton step is this small}

\item{return_all}{Return additional posterior covariance terms}

\item{y_init}{Specify initial guess for posterior mode}

\item{prior_mean}{specify the prior latent mean}

\item{vecchia.approx.IW}{an optional vecchia approximation object, can reduce computation if method is called repeatedly}
}
\value{
(multivariate normal) loglikelihood implied by the Vecchia approximation
}
\description{
Wrapper for VL version of vecchia_likelihood
}
