% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_likelihood.R
\name{vecchia_likelihood}
\alias{vecchia_likelihood}
\title{evaluation of the likelihood}
\usage{
vecchia_likelihood(z, vecchia.approx, covparms, nuggets,
  covmodel = "matern")
}
\arguments{
\item{z}{the observed data}

\item{vecchia.approx}{a vecchia object as generated by vecchia_specify()}

\item{covparms}{covariance parameters as a vector}

\item{nuggets}{either a single (constant) nugget or a vector of nugget terms for the observations}

\item{covmodel}{covariance model, 'matern' by default}
}
\value{
(multivariate normal) loglikelihood implied by the Vecchia approximation
}
\description{
evaluation of the likelihood
}
\examples{
z=rnorm(5); locs=matrix(1:5,ncol=1); vecchia.approx=vecchia_specify(locs,m=3)
vecchia_likelihood(z,vecchia.approx,covparms=c(1,2,.5),nuggets=.2)
}
