% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyapFDWolf.R
\name{lyapFDWolf}
\alias{lyapFDWolf}
\title{lyapFDWolf : computes Lyapunov spectrum with Wolf method}
\usage{
lyapFDWolf(outLyapFD = NULL, nVar, dMax, coeffF, intgrMthod = "rk4",
  tDeb = 0, dt, tFin, yDeb, Ddeb = NULL, nIterMin = 1,
  nIterStats = 50)
}
\arguments{
\item{outLyapFD}{List of output data that can be used
as an input in order to extend the computation}

\item{nVar}{Model dimension}

\item{dMax}{Maximum degree of the polynomial formulation}

\item{coeffF}{Model matrix. Each column correspond to
one equation. Lines provide the coefficients for each
polynomial term which order is defined with function
\code{poLabs(nVar, dMax)} in package \code{GPoM})}

\item{intgrMthod}{Numerical integration method
('rk4' by default)}

\item{tDeb}{Initial integration time (0 by default)}

\item{dt}{Integration time step}

\item{tFin}{Final integration time}

\item{yDeb}{Model initial conditions}

\item{Ddeb}{Jacobian initial conditions (optional).}

\item{nIterMin}{Minimum number of iterations (nIterMin= 1
by default)}

\item{nIterStats}{Number of iterations used in the statistics computation}
}
\value{
List of output data
}
\description{
Computes all the Lyapunov exponents based
on Gram-Schmidt procedure (Wolf et al. 1985).
The Jacobian matrix is computed from the original model
by semi-Formal Derivation.
}
\examples{
data(Ebola)
nVar = dim(Ebola$KL)[2]
pMax = dim(Ebola$KL)[1]
dMax = p2dMax(nVar, pMax)
outLyapFD <- NULL
outLyapFD$Wolf <- lyapFDWolf(outLyapFD$Wolf, nVar= nVar, dMax = dMax,
                             coeffF = Ebola$KL,
                             tDeb = 0, dt = 0.01, tFin = 2,
                             yDeb = Ebola$yDeb)

}
\references{
A. Wolf, J. B. Swift, H. L. Swinney & J. A. Vastano,
Determining Lyapunov exponents from a time series,
Physica D, 285-317, 1985.
}
