% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastfun.R
\docType{class}
\name{fastfun-class}
\alias{fastfun-class}
\alias{predict,fastfun-method}
\alias{update,fastfun-method}
\alias{simulate,fastfun-method}
\title{Class for fast to compute objective.}
\usage{
\S4method{predict}{fastfun}(object, newdata, ...)

\S4method{update}{fastfun}(object, newX, newy, ...)

\S4method{simulate}{fastfun}(object, nsim, seed, newdata, cond, nugget.sim,
  checkNames, ...)
}
\arguments{
\item{object}{\code{\link[GPareto]{fastfun}} object}

\item{newdata}{Matrix of the new location for the design}

\item{...}{further arguments (not used)}

\item{newX}{Matrix of the new location for the design}

\item{newy}{Matrix of the responses at \code{newX}}

\item{nsim}{an optional number specifying the number of response vectors to simulate. Default is 1.}

\item{seed}{usual seed argument of method simulate. Not used.}

\item{cond}{an optional boolean indicating the type of simulations. Not used.}

\item{nugget.sim}{an optional number corresponding to a numerical nugget effect. Not used.}

\item{checkNames}{an optional boolean. Not used.}

\item{object}{\code{\link[GPareto]{fastfun}} object}

\item{newdata}{an optional vector, matrix or data frame containing the points where to perform predictions.
Default is \code{NULL}: simulation is performed at design points specified in \code{object}.}

\item{...}{further arguments (not used)}
}
\description{
Class for fast to compute objective.
}
\section{Methods (by generic)}{
\itemize{
\item \code{predict}: Predict(by evaluating \code{fun}) the result at a new observation.

\item \code{update}: Update the \code{X} and \code{y} slots with a new design and observation.

\item \code{simulate}: Simulate responses values (for compatibility with methods using \code{\link[DiceKriging]{simulate}})
}}

\section{Slots}{

\describe{
\item{\code{d}}{spatial dimension,}

\item{\code{n}}{observations number,}

\item{\code{X}}{the design of experiments, size \code{n x d},}

\item{\code{y}}{the observations, size \code{n x 1},}

\item{\code{fun}}{the evaluator function.}
}}

\section{Objects from the Class }{
 To create a \code{fastfun} object, use \code{\link[GPareto]{fastfun}}. See also this function for more details and examples.
}

\keyword{internal}
