% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParetoEmp.R
\name{plotParetoEmp}
\alias{plotParetoEmp}
\title{Pareto front visualization}
\usage{
plotParetoEmp(nondominatedPoints, add = TRUE, max = FALSE, ...)
}
\arguments{
\item{nondominatedPoints}{points considered to plot the Pareto front with segments, matrix with one point per row,}

\item{add}{optional boolean indicating whether a new graphic should be drawn,}

\item{max}{optional boolean indicating whether to display a Pareto front in a maximization context,}

\item{...}{additional values to be passed to the \code{\link[graphics]{lines}} function.}
}
\description{
Plot the Pareto front with step functions.
}
\examples{
#------------------------------------------------------------
# Simple example
#------------------------------------------------------------

x <- c(0.2, 0.4, 0.6, 0.8)
y <- c(0.8, 0.7, 0.5, 0.1)

plot(x, y, col = "green", pch = 20) 

plotParetoEmp(cbind(x, y), col = "green")
## Alternative
plotParetoEmp(cbind(x, y), col = "red", add = FALSE)

## With maximization

plotParetoEmp(cbind(x, y), col = "blue", max = TRUE)
}

