% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_for_Game.R
\name{filter_for_Game}
\alias{filter_for_Game}
\title{All-purpose filter}
\usage{
filter_for_Game(n.s.target, model = NULL, predictions = NULL,
  type = "window", equilibrium = "NE", integcontrol, options = NULL,
  ncores = 1, random = TRUE, include.obs = FALSE, min.crit = 1e-12)
}
\arguments{
\item{n.s.target}{scalar or vector of number of strategies (one value per player) to select. For \code{NE}, if \code{n.s.target} is a scalar
then each player will have \code{round(n.s.target^(1/nobj)} strategies.}

\item{model}{is a list of \code{nobj} \code{nobj} \code{\link[DiceKriging]{km}} objects}

\item{predictions}{is a list of size \code{nobj}}

\item{type}{either "\code{window}", "\code{PND}" or "\code{Pnash}", see details}

\item{equilibrium}{either '\code{NE}', '\code{KSE}' or '\code{NKSE}' for Nash/Kalai-Smoridinsky/Nash-Kalai-Smoridinsky equilibria}

\item{integcontrol}{is a list containing: \code{integ.pts}, a [\code{npts x dim}] matrix defining the grid,
\code{expanded.indices} a matrix containing the indices of the integ.pts on the grid and \code{n.s},
a \code{nobj} vector containting the number of strategies per player}

\item{options}{a list containing either the window (matrix or target) or the parameters for Pnash: method
("\code{simu}" or "\code{exact}") and \code{nsim}}

\item{ncores}{\code{\link[parallel]{mclapply}} is used if \code{> 1} for parallel evaluation}

\item{random}{Boolean. If \code{FALSE}, the best points according to the filter criterion are chosen,
otherwise the points are chosen by random sampling with weights proportional to the criterion.}

\item{include.obs}{Boolean. If \code{TRUE}, the observations are included to the filtered set.}

\item{min.crit}{Minimal value for the criterion, useful if \code{random = TRUE}.}
}
\value{
List with two elements: \code{I} indices selected and \code{crit} the filter metric at all candidate points
}
\description{
Select candidate points for conditional simulations or for criterion evaluation, based on a "window" or a probability related to the equilibrium at hand.
}
\details{
If \code{type == "windows"}, points are ranked based on their distance to \code{option$window} (when it is a target vector),
or based on the probability that the response belongs to \code{option$window}.
The other options, "\code{PND}" (probability of non-domination, i.e., of not being dominated by the current Pareto front)
and "\code{Pnash}" (probability of realizing a Nash equilibrium) base the ranking of points on the associated probability.
}

